---
type: glossary
tags:
  - "#layer/information"
  - "#status/stable"
  - "#function/observation"
aliases:
  - Containment
  - Embedding
---

# Containment : Embedding (relation)

> Part-of / scope nesting; expresses R(·) depth and context.

---

## Definition

- Scope nesting pattern
- Layer containment rule
- Part-whole relation
- Context embedding

---

## Dual‑register mapping

### Technical (network/computational)

| Diagnostic concept | Network construct | Test example |
|-------------------|------------------|--------------|
| Scope nest | Layer hold | `Monitor`, `Nest` |
| Part whole | Inside check | `Check`, `Part` |
| Context depth | Level test | `Test`, `Depth` |

### Humane (biological/relational)

| Diagnostic concept | Humane construct | Example |
|-------------------|------------------|----------|
| Scope nest | Inside space | "Contains it" |
| Part whole | Belongs to | "Part of it" |
| Context depth | Layer deep | "Within it" |

### Crosswalk (bridge)

| Technical term | Humane term | Ontological meaning |
|---------------|-------------|-------------------|
| Layer hold | Inside space | How nesting works |
| Inside check | Belongs to | How parts fit |
| Level test | Layer deep | How depth forms |

### Domain Examples

| Domain | Technical test | Humane test |
|--------|---------------|-------------|
| Physics | Space nest | Force hold |
| Networks | Layer deep | Node nest |
| Cognition | Mind nest | Think deep |
| Systems | State hold | Flow nest |

---

## Scale Effects

How Containment manifests differently at various scales:

### Micro Scale (ε-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ε | Quantum nest | Wave hold |
| λV | Gate deep | State nest |

### Human Scale (ψA-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ψA | Phase nest | Pattern hold |
| ∇S | Structure deep | Clear nest |

### Cosmic Scale (c-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| c | Wave nest | Light hold |
| λV | Field deep | Space nest |

Note: At extreme scales, containment faces fundamental limits (e.g., quantum nesting at ε, causal depth at c).

---

## Invariants / Thresholds

Scale-dependent bounds:
- ε: nest clarity
- c: depth limit
- ψA: phase hold
- λV: gate nest

---

## SVA Coupling

Scale-dependent modulator effects:

| Scale | Modulator | Technical effect | Humane effect |
|-------|-----------|-----------------|---------------|
| Micro | ∇S | Pattern nest | Wave hold |
| Human | λV | Gate deep | Flow nest |
| Cosmic | ψA | Phase hold | Field deep |

---

## Failure Modes

Scale-dependent failure patterns:

| Scale | Mode | Technical signature | Humane signature |
|-------|------|-------------------|------------------|
| Micro | Nest leak | Pattern spill | Not held |
| Human | Part fail | Flow escape | Not inside |
| Cosmic | Depth loss | Field leak | No nest |

---

## Diagnostic Checklist

Technical tests:
- [ ] Nest clear
- [ ] Part checked
- [ ] Depth known
- [ ] Hold works

Humane tests:
- [ ] Inside good
- [ ] Belongs well
- [ ] Layer felt
- [ ] Holds true

---

## Design rationale

This diagnostic must maintain dual-register intelligibility per governance (see [PRINCIPLES.md](../../../../PRINCIPLES.md)). Neither technical containment nor experiential belonging alone captures its full meaning.

---

## See Also

- [[Adjacency : Incidence (relation)]]
- [[Dependency : Constraint (relation)]]
- [[Ribbed Relational Embedding (property)]]
- [[Form]]
- [[Field]]

---

## Dual‑register checklist

- [x] Technical mapping provided
- [x] Humane mapping provided
- [x] Crosswalk table included
- [x] Scale-aware tests documented